Imports System.Resources
Imports System.Windows.Forms
Imports System.Drawing

Module Module1

    Sub Main()
        ' Crer un nouveau fichier *resources.
        Dim rw As ResourceWriter
        rw = New ResourceWriter("myResources.resources")

        ' Ajouter une image et une chane.
        rw.AddResource("happyDude", New Bitmap("happy.bmp"))
        rw.AddResource("welcomeString", "Bienvenue aux ressources .NET.")
        rw.Generate()
        rw.Close()
        MessageBox.Show("Tout est fait!")
        Dim r As MyResourceReader = New MyResourceReader()
        r.ReadMyResources()
    End Sub

End Module

Class MyResourceReader
    Public Sub ReadMyResources()      
        ' Ouvrir le fichier ressource.
        Dim rm As ResourceManager = New ResourceManager("myResources", _
                  System.Reflection.Assembly.GetExecutingAssembly())

        ' Charger la ressource image.
        Dim p As PictureBox = New PictureBox()
        Dim b As Bitmap = CType(rm.GetObject("happyDude"), Bitmap)
        p.Image = b
        p.Height = b.Height
        p.Width = b.Width
        p.Location = New Point(10, 10)

        ' Charger la ressource chane.
        Dim label1 As Label = New Label()
        label1.Location = New Point(50, 10)
        label1.Font = New Font(label1.Font.FontFamily, 12, FontStyle.Bold)
        label1.AutoSize = True
        label1.Text = rm.GetString("welcomeString")

        ' Construire un formulaire pour montrer les ressources.
        Dim f As Form = New Form()
        f.Height = 100
        f.Width = 370
        f.Text = "Ces ressources sont imbriques dans l'assembly!"

        ' Ajouter les contrles et afficher le formulaire.
        f.Controls.Add(p)
        f.Controls.Add(label1)
        f.ShowDialog()
    End Sub
End Class
